<?php
require_once "php/config.php";
require_once "php/category.php";
require_once "php/functions.php";
require_once "php/language.php";
require_once "php/translate.php";

$level1=getCategories($pdo,1,null,$lang);

?>

<!doctype html>
<html lang="<?= $lang ?>" dir="<?= in_array($lang, ['fa','ar']) ? 'rtl' : 'ltr' ?>">
    <head>
<meta charset="utf-8" name="viewport" content="width=device-width, initial-scale=1" />
<title>مدیریت دسته‌ها</title>
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.2/Sortable.min.js"></script>
<script type="module" src="js/main.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
<link href="css/admin.css?v=1.2" rel="stylesheet">
<?php if ($dir === 'rtl'): ?>
<link href="css/admin-rtl.css?v=1.0" rel="stylesheet">
<?php else: ?>
<link href="css/admin-ltr.css?v=1.0" rel="stylesheet">
<?php endif; ?>

<style>

</style>
</head>
<body class="container py-4">
    <section class="header">
        <?php require_once "section/header.php"; ?>
    </section>
    <section class="main">
<div class="menu-top">
  <a href="/lang" class="<?= $lang=='fa'?'active':'' ?>"> 
  مدیریت زبان
  </a>
</div>

        <h1><t>add_new_collection</t></h1>

 <label for="toggle1" class="show-button">
                        <span class="icon-plus"></span>
                        <span class="name-plus"> 
                        افزودن مجموعه
                        </span>
                        </label>

toggle
<div class="language-menu">
  <ul>
    <?php foreach ($languages as $lg): ?>
      <li>
        <a href="?set_lang=<?= $lg['code'] ?>" 
           style="<?= $lg['is_default'] ? 'font-weight:bold;color:green;' : '' ?>">
           <?= htmlspecialchars($lg['name']) ?>
           <?= $lg['is_default'] ? '✅' : '' ?>
        </a>
      </li>
    <?php endforeach; ?>
  </ul>
</div>


<h4 class="mb-3">مدیریت دسته‌ها (سه سطحی)</h4>
                    
                   <!-- افزودن مجموعه -->
                <div class="add-form-class form-level1-class">
                    <label for="toggle" class="show-button">
                        <span class="icon-plus"></span>
                        <span class="name-plus"> 
                        افزودن مجموعه
                        </span>
                        </label>
        <input type="checkbox" id="toggle">
        <div class="hidden-creature">
        <div class="creature-content">
                <!-- فرم افزودن دسته سطح ۱ -->
<div class="form-main">
    <div class="form-main-header">
    <label for="toggle" class="close-button"><i class="fas fa-times"></i></label>
    <h3>افزودن مجموع جدید</h3>
    </div>
<!-- ================= فرم افزودن سطح ۱ ================= -->

    <?php require_once "form/form_add_level1.php"; ?>

</div>
        </div>
        </div>
                       </div>  

                <!-- نمایش و فرم های مجموعه یک -->
<!-- سطح ۱ -->
<ul class="list-group mb-3 level1" data-level="1" data-parent="">
<?php foreach($level1 as $l1): 
    $name1=$l1['Name'] ?: "Category ".$l1['CategoryID'];
    $level2=getCategories($pdo,2,$l1['CategoryID'],$lang);
?>

<li class="list-group-item draggable-item" data-id="<?=$l1['CategoryID']?>">
  <div class="accordion" id="acc<?=$l1['CategoryID']?>">
    <div class="accordion-item">
        <div class="header-level1">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed level1-h1" type="button" data-bs-toggle="collapse" data-bs-target="#col<?=$l1['CategoryID']?>">
                    <div class="handle">☰☰</div> 
                    <div class="name-level1"> <?=htmlspecialchars($name1)?></div>  
                </button>
                    <div class="icon-admin">
                        <i class="fas fa-plus" title="افزودن زیردسته"></i>
                        <i class="fas fa-edit" title="ویرایش دسته"></i>
                         <i class="fas fa-trash" title="حذف دسته"></i>
                    </div>
            </h2>
        </div>
        
       <!-- باکس هشدار حذف -->
<div class="box-icon hidden-box box-delete confirm-delete">
       <div class="warning-message">
      ⚠️ این عنوان و تمام زیرمجموعه‌ها کامل پاک می‌شود و امکان بازگردانی نیست.
   </div>
   <div class="form-actions">
      <button type="button" class="btn-confirm-delete" data-id="<?=$l1['CategoryID']?>">تأیید</button>
      <button type="button" class="btn-cancel">انصراف</button>
   </div>
</div>
        <!-- فرم افزودن زیردسته -->
<div class="box-icon hidden-box box-add">
       <form class="add-sub-form" data-parent="<?=$l1['CategoryID']?>" data-level="2">
      <?php foreach(['fa'=>'فارسی','en'=>'انگلیسی','tr'=>'ترکی','ar'=>'عربی'] as $lg=>$label): ?>
      <div class="form-group">
        <input type="text" name="name_<?=$lg?>" placeholder="نام <?=$label?>">
      </div>
      <?php endforeach; ?>
      <div class="form-actions">
        <button type="submit" class="btn-submit">ذخیره</button>
        <button type="button" class="btn-cancel">انصراف</button>
      </div>
   </form>
</div>
        <!-- فرم ویرایش سطح ۱ -->
<div class="box-icon hidden-box box-edit">
     <div class="form-main-header">
   
     <span class="close-btn"><i class="fa fa-times"></i></span>
  <h3>افزودن زیرمجموعه</h3>
   

    </div>
               <form class="edit-form" data-id="<?=$l1['CategoryID']?>">
              <?php foreach(['fa'=>'فارسی','en'=>'انگلیسی','tr'=>'ترکی','ar'=>'عربی'] as $lg=>$label): ?>
              <div class="form-group">
                <input type="text" name="name_<?=$lg?>" placeholder="نام <?=$label?>" 
                 value="<?=htmlspecialchars(getTranslation($pdo,$l1['CategoryID'],$lg))?>">
              </div>
              <?php endforeach; ?>
              <div class="form-actions">
                <button type="submit" class="btn-submit">ذخیره</button>
                <button type="button" class="btn-cancel">انصراف</button>
              </div>
           </form>
        </div>
        
                        <!--   نمایش و فرم سطح دو-->
      <div id="col<?=$l1['CategoryID']?>" class="accordion-collapse collapse">
        <div class="accordion-body">
          <!-- سطح ۲ -->
          <ul class="list-group level2" data-level="2" data-parent="<?=$l1['CategoryID']?>">
          <?php foreach($level2 as $l2):
              $name2=$l2['Name'] ?: "Category ".$l2['CategoryID'];
              $level3=getCategories($pdo,3,$l2['CategoryID'],$lang);
          ?>
            <li class="list-group-item draggable-item" data-id="<?=$l2['CategoryID']?>">
              <div class="accordion" id="acc2<?=$l2['CategoryID']?>">
                <div class="accordion-item ">
                <div class="header-level1">
                  <h2 class="accordion-header">
                    <button class="accordion-button level2-h1 collapsed " type="button" data-bs-toggle="collapse" data-bs-target="#col2<?=$l2['CategoryID']?>">
                        <div class="handle">☰</div> 
                        <div class="name-level1"> <?=htmlspecialchars($name2)?></div>  
                    </button>
                         <div class="icon-admin">
                            <i class="fas fa-plus" title="افزودن زیردسته"></i>
                            <i class="fas fa-edit" title="ویرایش دسته"></i>
                           <i class="fas fa-trash" title="حذف دسته"></i>
                        </div>
                  </h2>
                  </div>
 
 
  <!-- باکس هشدار حذف -->
<div class="box-icon hidden-box box-delete confirm-delete">
       <div class="warning-message">
      ⚠️ این عنوان و تمام زیرمجموعه‌ها کامل پاک می‌شود و امکان بازگردانی نیست.
   </div>
   <div class="form-actions">
      <button type="button" class="btn-confirm-delete" data-id="<?=$l2['CategoryID']?>">تأیید</button>
      <button type="button" class="btn-cancel">انصراف</button>
   </div>
</div>
                
                  <!-- فرم افزودن زیردسته -->
<!-- فرم افزودن آیتم سطح ۳ -->
<div class="box-icon hidden-box box-add">
   <form class="add-item-form" data-parent="<?=$l2['CategoryID']?>" enctype="multipart/form-data">
      <?php foreach(['fa'=>'فارسی','en'=>'انگلیسی','tr'=>'ترکی','ar'=>'عربی'] as $lg=>$label): ?>
      <div class="form-group">
        <input type="text" name="name_<?=$lg?>" placeholder="نام <?=$label?>">
        <textarea name="desc_<?=$lg?>" placeholder="توضیح <?=$label?>"></textarea>
      </div>
      <?php endforeach; ?>
      <div class="form-group">
        <input type="text" name="price" placeholder="قیمت">
      </div>
      <div class="form-group">
        <input type="file" name="image">
      </div>
      <div class="form-actions">
        <button type="submit" class="btn-submit">ذخیره</button>
        <button type="button" class="btn-cancel">انصراف</button>
      </div>
   </form>
</div>
                  
                       <!-- فرم ویرایش سطح ۲ -->
<div class="box-icon hidden-box box-edit">
                 <form class="edit-form" data-id="<?=$l2['CategoryID']?>">
                <?php foreach(['fa'=>'فارسی','en'=>'انگلیسی','tr'=>'ترکی','ar'=>'عربی'] as $lg=>$label): ?>
                <div class="form-group">
                  <input type="text" name="name_<?=$lg?>" placeholder="نام <?=$label?>" 
                   value="<?=htmlspecialchars(getTranslation($pdo,$l2['CategoryID'],$lg))?>">
                </div>
                <?php endforeach; ?>
                <div class="form-actions">
                  <button type="submit" class="btn-submit">ذخیره</button>
                  <button type="button" class="btn-cancel">انصراف</button>
                </div>
             </form>
          </div>
          
                   <!--  نمایش و فرم سطح 3 -->
                  <div id="col2<?=$l2['CategoryID']?>" class="accordion-collapse collapse">
                    <div class="accordion-body">
                      <!-- سطح ۳ -->
                      <ul class="list-group level3" data-level="3" data-parent="<?=$l2['CategoryID']?>">
                      <?php foreach($level3 as $l3):
                          $name3=$l3['Name'] ?: "Category ".$l3['CategoryID'];
                          $det=getItemDetail($pdo,$l3['CategoryID'],$lang);
                      ?>
                        <li class="list-group-item draggable-item" data-id="<?=$l3['CategoryID']?>">
                            <div class="item-class">
                                <div class="name-sub">
                                    <div class="name-level3">
                                    <span class="handle">⋮</span>
                                    <span class="name-item"><?=htmlspecialchars($name3)?></span>
                                    </div>
                                    <div class="icon-admin icon-level3">
                                        <i class="fas fa-trash" title="حذف آیتم"></i>
                                        <i class="fas fa-edit" title="ویرایش آیتم"></i>
                                    </div>
                                </div>
                                
                                
            
            <!-- باکس هشدار حذف -->
<div class="box-icon hidden-box box-delete confirm-delete">
       <div class="warning-message">
      ⚠️ این عنوان و تمام زیرمجموعه‌ها کامل پاک می‌شود و امکان بازگردانی نیست.
   </div>
   <div class="form-actions">
      <button type="button" class="btn-confirm-delete" data-id="<?=$l3['CategoryID']?>">تأیید</button>
      <button type="button" class="btn-cancel">انصراف</button>
   </div>
</div>

<!-- فرم ویرایش سطح ۳ -->
<div class="box-icon hidden-box box-edit">
    <form id="edit-item-<?= $l3['CategoryID'] ?>" class="edit-item-form" 
          data-id="<?= $l3['CategoryID'] ?>" enctype="multipart/form-data">

        <!-- دکمه افزودن/بستن زبان‌ها -->
        <div class="form-group">
  <button type="button" class="btn-toggle-lang" data-target="langs-<?= $l3['CategoryID'] ?>">
    <span class="icon-plus"></span>
    <span class="name-plus">افزودن زبان</span>
  </button>
</div>

        <!-- زبان‌ها -->
        <div id="langs-<?= $l3['CategoryID'] ?>" class="lang-container">
            <?php 
            foreach(['fa'=>'فارسی','en'=>'انگلیسی','tr'=>'ترکی','ar'=>'عربی'] as $lg=>$label): 
                $divClass = ($lg === $default_lang) ? 'base-level3' : 'hidden-level3';
            ?>
            <div class="<?= $divClass ?>">
                <div class="form-group edit-form-name">
                    <input type="text" name="name_<?= $lg ?>" 
                           value="<?= htmlspecialchars(getTranslation($pdo,$l3['CategoryID'],$lg)) ?>" 
                           placeholder="نام <?= $label ?>">
                </div>
                <div class="form-group edit-form-dec">
                    <textarea name="desc_<?= $lg ?>" 
                              placeholder="توضیح <?= $label ?>"><?= htmlspecialchars($det['Description'] ?? '') ?></textarea>
                </div>
            </div>
            <?php endforeach; ?>
        </div>

 <div class="edit-form-bottom">
        <!-- قیمت -->
        <div class="form-group edit-form-price">
            <input type="text" name="price" value="<?= htmlspecialchars($det['Price'] ?? '') ?>" placeholder="قیمت">
        </div>
 <!-- آپلود تصویر -->
        <div class="form-group edit-form-image">
            <div class="fileUpload">
            <input type="file" class="upload" name="image" accept="image/*" onchange="previewImage(this, 'preview-<?= $l3['CategoryID'] ?>')">
<span>Upload</span>
         </div>
         </div>
         
        <?php if(!empty($det['Image'])): ?>
    <div class="form-group edit-form-image2">
        <label>تصویر فعلی:</label><br>
        <img src="<?= htmlspecialchars($det['Image']) ?>" 
             id="preview-<?= $l3['CategoryID'] ?>" 
             style="max-width:150px; max-height:150px;">
    </div>

    <!-- فقط وقتی تصویر وجود داره -->
    <div class="form-group edit-form-image4">
        <label>
            <input type="checkbox" class="option-input radio" name="delete_image" value="1"> حذف تصویر
        </label>
    </div>

<?php else: ?>
    <div class="form-group edit-form-image3">
        <img id="preview-<?= $l3['CategoryID'] ?>" 
             style="max-width:150px; max-height:150px; display:none;">
    </div>
<?php endif; ?>
        <!-- دکمه‌ها -->
        <div class="form-actions  edit-form-button">
            <button type="submit" class="btn-submit">ذخیره</button>
            <button type="button" class="btn-cancel">انصراف</button>
        </div>
        </div>
    </form>
</div>

<div id="loading-overlay" style="
    display:none;
    position:fixed;
    top:0; left:0;
    width:100%; height:100%;
    background:rgba(255,255,255,0.8);
    z-index:9999;
    text-align:center;
    padding-top:20%;
    font-size:20px;
    font-weight:bold;
    color:#333;
">
  ⏳ لطفا منتظر بمانید... در حال بارگزاری
</div>




                                <div class="details" style="display:block;">
                                    <div><b>قیمت:</b> <?=$det['Price']??'—'?></div>
                                    <div><b>توضیح:</b> <?=$det['Description']??'—'?></div>
                                </div>
                            </div>
                        </li>
                      <?php endforeach; ?>
                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </li>
          <?php endforeach; ?>
          </ul>
        </div>
      </div>
    </div>
  </div>
</li>
<?php endforeach; ?>
</ul>

<!-- Toast -->
<div class="toast-container">
  <div id="toastSaved" class="toast align-items-center text-bg-success border-0" role="alert">
    <div class="d-flex">
      <div class="toast-body">ترتیب با موفقیت ذخیره شد ✅</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
    </div>
  </div>
</div>
</section>




    <script>
// ----------- فعال‌سازی Sortable برای همه سطوح -----------
function makeSortable(sel, groupName) {
  document.querySelectorAll(sel).forEach(function(el) {
    new Sortable(el, {
      group: groupName,
      handle: '.handle',
      animation: 250,
      ghostClass: 'sortable-ghost',
      chosenClass: 'sortable-chosen',
      dragClass: 'sortable-drag',
      forceFallback: true,
      fallbackOnBody: true,
      fallbackTolerance: 3,
      onStart: evt => evt.item.classList.add('dragging'),
      onEnd: function(evt) {
        evt.item.classList.remove('dragging');
        let toEl = evt.to;
        let ids = [...toEl.querySelectorAll(":scope > li")].map(li => li.dataset.id);
        let parent = toEl.dataset.parent || '';
        let level = toEl.dataset.level;
        saveOrder(level, parent, ids);
      }
    });
  });
}

// ----------- ذخیره ترتیب در دیتابیس -----------
function saveOrder(level, parent_id, ids) {
  let data = new URLSearchParams();
  data.append("action", "save_order");
  data.append("level", level);
  data.append("parent_id", parent_id);
  ids.forEach(id => data.append("order[]", id));

  fetch("", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: data
  }).then(r => r.json()).then(d => {
    if (d.success) {
      let toastEl = document.getElementById('toastSaved');
      if (toastEl) {
        let toast = new bootstrap.Toast(toastEl);
        toast.show();
      }
    } else {
      alert("خطا: " + (d.message || ''));
    }
  });
}

// ----------- پیش‌نمایش تصویر -----------
function previewImage(input, previewId) {
  const preview = document.getElementById(previewId);
  if (input.files && input.files[0]) {
    const reader = new FileReader();
    reader.onload = e => {
      preview.src = e.target.result;
      preview.style.display = 'block';
    };
    reader.readAsDataURL(input.files[0]);
  }
}

// ----------- مدیریت سوئیچ زبان -----------
function switchLang(itemId, lang) {
  // همه باکس‌های این آیتم را مخفی کن
  document.querySelectorAll('.lang-box-' + itemId).forEach(el => {
    el.classList.remove('base-level3');
    el.classList.add('hidden-level3');
  });

  // فقط زبان انتخابی را فعال کن
  let activeBox = document.querySelector('.lang-box-' + itemId + '[data-lang="' + lang + '"]');
  if (activeBox) {
    activeBox.classList.remove('hidden-level3');
    activeBox.classList.add('base-level3');
  }
}

// ----------- مدیریت رویدادهای DOM -----------
document.addEventListener("DOMContentLoaded", () => {
  makeSortable('.level1', 'shared');
  makeSortable('.level2', 'shared');
  makeSortable('.level3', 'shared');

  // فرم افزودن سطح 1
  const formLevel1 = document.getElementById("add_level1");
  if (formLevel1) {
    formLevel1.addEventListener("submit", function(e) {
      e.preventDefault();
      const formData = new FormData(this);
      formData.append("action", "add_category");
      formData.append("level", 1);
      formData.append("parent_id", "");

      fetch("", { method: "POST", body: formData })
        .then(res => res.json())
        .then(data => {
          if (data.success) {
            alert("✅ دسته سطح یک اضافه شد");
            location.reload();
          } else {
            alert("❌ خطا: " + (data.message || "عملیات ناموفق بود"));
          }
        })
        .catch(err => alert("❌ خطای ارتباط: " + err));
    });
  }

  // هندل همه فرم‌ها
  document.addEventListener('submit', function(e) {
    const form = e.target;

    // افزودن آیتم سطح 3
    if (form.classList.contains('add-item-form')) {
      e.preventDefault();
      let data = new FormData(form);
      data.append('action', 'add_item');
      data.append('parent_id', form.dataset.parent);

      fetch("", { method: "POST", body: data })
        .then(r => r.json()).then(d => {
          if (d.success) { alert("آیتم افزوده شد ✅"); location.reload(); }
          else { alert("خطا: " + d.message); }
        });
    }

    // ویرایش آیتم سطح 3
    else if (form.classList.contains('edit-item-form')) {
      e.preventDefault();
      let id = form.dataset.id;
      let data = new FormData(form);
      data.append('action', 'edit_item');
      data.append('id', id);

      fetch("", { method: "POST", body: data })
        .then(r => r.json()).then(d => {
          if (d.success) { alert("ویرایش شد ✅"); location.reload(); }
          else { alert("خطا: " + (d.message || '')); }
        });
    }

    // افزودن زیردسته سطح 2
    else if (form.classList.contains('add-sub-form')) {
      e.preventDefault();
      let parent = form.dataset.parent;
      let level = form.dataset.level;
      let data = new FormData(form);
      data.append('action', 'add_category');
      data.append('parent_id', parent);
      data.append('level', level);

      fetch("", { method: "POST", body: data })
        .then(r => r.json()).then(d => {
          if (d.success) { alert("زیردسته افزوده شد ✅"); location.reload(); }
          else { alert("خطا: " + d.message); }
        });
    }

    // ویرایش دسته سطح 1 و 2
    else if (form.classList.contains('edit-form')) {
      e.preventDefault();
      let id = form.dataset.id;
      let data = new FormData(form);
      data.append('action', 'edit_category');
      data.append('id', id);

      fetch("", { method: "POST", body: data })
        .then(res => res.json())
        .then(d => {
          if (d.success) {
            alert("ویرایش شد ✅");
            location.reload();
          } else {
            alert("خطا: " + (d.message || ''));
          }
        });
    }
  });

  // مدیریت دکمه‌های تغییر زبان
  document.querySelectorAll(".btn-toggle-lang").forEach(btn => {
    btn.addEventListener("click", function() {
      let target = document.getElementById(this.dataset.target);
      let hiddenFields = target.querySelectorAll(".hidden-level3");

      let name = this.querySelector(".name-plus");

      if (this.classList.contains("close")) {
        // بستن زبان‌ها
        hiddenFields.forEach(div => div.style.display = "none");

        name.textContent = "افزودن زبان";
        this.classList.remove("close");
      } else {
        // باز کردن زبان‌ها
        hiddenFields.forEach(div => div.style.display = "block");

        name.textContent = "بستن زبان‌ها";
        this.classList.add("close");
      }
    });
  });

  // ذخیره تب فعال هنگام کلیک
  document.querySelectorAll(".btn-toggle-lang").forEach(btn => {
    btn.addEventListener("click", function() {
      let targetId = this.dataset.target;
      localStorage.setItem("activeTab", targetId);
    });
  });

  // باز کردن تب ذخیره‌شده پس از لود صفحه
  let activeTab = localStorage.getItem("activeTab");
  if (activeTab) {
    let btn = document.querySelector(`.btn-toggle-lang[data-target="${activeTab}"]`);
    let target = document.getElementById(activeTab);
    if (btn && target) {
      target.querySelectorAll(".hidden-level3").forEach(div => div.style.display = "block");
      let name = btn.querySelector(".name-plus");
      if (name) {
        name.textContent = "بستن زبان‌ها";
      }
      // اگر آیکونی وجود دارد، می‌توان تغییر داد، اما در کد اصلی icon-plus نیست، پس کامنت می‌کنم
      // btn.querySelector(".icon-plus").textContent = "✖";
      btn.classList.add("close");
    }
  }

  // نمایش لودینگ هنگام ارسال فرم ویرایش آیتم
  document.querySelectorAll(".edit-item-form").forEach(form => {
    form.addEventListener("submit", function(e) {
      document.getElementById("loading-overlay").style.display = "block";
    });
  });

  // مدیریت کلیک‌ها برای آیکون‌ها
  document.addEventListener('click', function(e) {
    const t = e.target;

    // حذف دسته
    if (t.classList.contains('fa-trash')) {
      const parent = t.closest('.draggable-item');
      parent.querySelectorAll('.box-icon').forEach(b => b.classList.remove('active'));
      const box = parent.querySelector('.box-delete');
      if (box) box.classList.add('active');
    }

    if (t.classList.contains('btn-confirm-delete')) {
      let id = t.dataset.id;
      let data = new FormData();
      data.append('action', 'delete_category');
      data.append('id', id);

      fetch("", { method: "POST", body: data })
        .then(r => r.json()).then(d => {
          if (d.success) { alert("حذف شد ✅"); location.reload(); }
          else { alert("خطا: " + (d.message || '')); }
        });
    }

    // افزودن زیردسته
    if (t.classList.contains('fa-plus')) {
      const parent = t.closest('.draggable-item');
      parent.querySelectorAll('.box-icon').forEach(b => b.classList.remove('active'));
      const box = parent.querySelector('.box-add');
      if (box) box.classList.add('active');
    }

    // ویرایش دسته
    if (t.classList.contains('fa-edit')) {
      const parent = t.closest('.draggable-item');
      parent.querySelectorAll('.box-icon').forEach(b => b.classList.remove('active'));
      const box = parent.querySelector('.box-edit');
      if (box) box.classList.add('active');
    }
  });
});

// ----------- مدیریت بستن باکس‌ها -----------
document.querySelectorAll(".close-btn").forEach(function(btn) {
  btn.addEventListener("click", function() {
    let parentBox = btn.closest(".box-icon");
    if (parentBox) {
      parentBox.classList.remove("active");
    }
  });
});

document.querySelectorAll(".btn-cancel").forEach(function(btn) {
  btn.addEventListener("click", function() {
    let parentBox = btn.closest(".box-icon");
    if (parentBox) {
      parentBox.classList.remove("active");
    }
  });
});
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php
// در پایان فایل خروجی را flush کن تا جایگزینی انجام شود
ob_end_flush();