<?php
// اتصال به دیتابیس
$host = "localhost";
$db   = "tabrizli_arkbam";
$user = "tabrizli_arkbamuser";
$pass = "01478520Mi!!";
$charset = "utf8mb4";

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];
try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    die("خطا در اتصال: " . $e->getMessage());
}

// ---------- انتخاب زبان ----------
$lang = $_GET['lang'] ?? 'fa';

// ---------- ذخیره ترتیب ----------
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='save_order') {
    header('Content-Type: application/json; charset=utf-8');
    $level = (int)($_POST['level'] ?? 0);
    $parent_id = $_POST['parent_id']!=='' ? (int)$_POST['parent_id'] : null;
    $order = $_POST['order'] ?? [];

    try {
        $pdo->beginTransaction();
        $stmt = $pdo->prepare("UPDATE Category SET SortOrder=:sort, ParentID=:parent, Level=:level WHERE CategoryID=:id");
        $s=1;
        foreach ($order as $id) {
            $stmt->execute([
                ':sort'=>$s++,
                ':parent'=>$parent_id,
                ':level'=>$level,
                ':id'=>(int)$id
            ]);
        }
        $pdo->commit();
        echo json_encode(['success'=>true]);
    } catch(Exception $e){
        $pdo->rollBack();
        echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
    }
    exit;
}


// ---------- حذف دسته ----------
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='delete_category') {
    header('Content-Type: application/json; charset=utf-8');
    $id = (int)$_POST['id'];

    try{
        $pdo->beginTransaction();

        // حذف همه ترجمه‌ها
        $stmt=$pdo->prepare("DELETE FROM CategoryTranslation WHERE CategoryID=:id");
        $stmt->execute([':id'=>$id]);

        // حذف آیتم‌های مربوط (اختیاری - بسته به ساختار دیتابیس)
        $stmt=$pdo->prepare("DELETE FROM ItemDetail WHERE CategoryID=:id");
        $stmt->execute([':id'=>$id]);

        // حذف زیرمجموعه‌ها (بازگشتی)
        $stmt=$pdo->prepare("SELECT CategoryID FROM Category WHERE ParentID=:id");
        $stmt->execute([':id'=>$id]);
        $subs=$stmt->fetchAll(PDO::FETCH_COLUMN);
      function deleteCategory(PDO $pdo, int $id) {
    // حذف ترجمه‌ها
    $stmt=$pdo->prepare("DELETE FROM CategoryTranslation WHERE CategoryID=:id");
    $stmt->execute([':id'=>$id]);

    // حذف آیتم‌ها
    $stmt=$pdo->prepare("DELETE FROM ItemDetail WHERE CategoryID=:id");
    $stmt->execute([':id'=>$id]);

    // گرفتن زیرمجموعه‌ها
    $stmt=$pdo->prepare("SELECT CategoryID FROM Category WHERE ParentID=:id");
    $stmt->execute([':id'=>$id]);
    $subs=$stmt->fetchAll(PDO::FETCH_COLUMN);

    foreach($subs as $sub){
        deleteCategory($pdo,(int)$sub); // فراخوانی بازگشتی تابع
    }

    // حذف خود دسته
    $stmt=$pdo->prepare("DELETE FROM Category WHERE CategoryID=:id");
    $stmt->execute([':id'=>$id]);
}
        $pdo->commit();
        echo json_encode(['success'=>true]);
    }catch(Exception $e){
        $pdo->rollBack();
        echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
    }
    exit;
}

// ---------- افزودن دسته ----------
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='add_category') {
    header('Content-Type: application/json; charset=utf-8');
    $parent_id = $_POST['parent_id']!=='' ? (int)$_POST['parent_id'] : null;
    $level = (int)$_POST['level'];
    $langs=['fa','en','tr','ar'];

    try{
        $pdo->beginTransaction();
        // درج دسته
        $stmt=$pdo->prepare("INSERT INTO Category (ParentID, Level, SortOrder) VALUES (:p,:lvl,0)");
        $stmt->execute([':p'=>$parent_id, ':lvl'=>$level]);
        $cat_id=$pdo->lastInsertId();

        // درج ترجمه‌ها
        foreach($langs as $lg){
            $name=$_POST["name_$lg"] ?? '';
            $stmt=$pdo->prepare("INSERT INTO CategoryTranslation (CategoryID,LanguageCode,Name)
                                 VALUES (:id,:lg,:name)");
            $stmt->execute([':id'=>$cat_id,':lg'=>$lg,':name'=>$name]);
        }

        $pdo->commit();
        echo json_encode(['success'=>true]);
    }catch(Exception $e){
        $pdo->rollBack();
        echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
    }
    exit;
}

// ---------- ویرایش دسته ----------
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='edit_category') {
    header('Content-Type: application/json; charset=utf-8');
    $id=(int)$_POST['id'];
    $langs=['fa','en','tr','ar'];

    try{
        $pdo->beginTransaction();
        foreach($langs as $lg){
            $name=$_POST["name_$lg"] ?? '';
            $stmt=$pdo->prepare("INSERT INTO CategoryTranslation (CategoryID,LanguageCode,Name)
                                 VALUES (:id,:lg,:name)
                                 ON DUPLICATE KEY UPDATE Name=:name");
            $stmt->execute([':id'=>$id,':lg'=>$lg,':name'=>$name]);
        }
        $pdo->commit();
        echo json_encode(['success'=>true]);
    }catch(Exception $e){
        $pdo->rollBack();
        echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
    }
    exit;
}





// ---------- افزودن آیتم سطح ۳ ----------
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='add_item') {
    header('Content-Type: application/json; charset=utf-8');
    $parent_id = (int)($_POST['parent_id'] ?? 0);
    $langs = ['fa','en','tr','ar'];
    $price = $_POST['price'] ?? null;
    $image = null;

    $uploadDir = __DIR__."/uploads/";
    if(!is_dir($uploadDir) && !mkdir($uploadDir,0777,true)){
        echo json_encode(['success'=>false,'message'=>'پوشه uploads ساخته نشد یا دسترسی ندارد']);
        exit;
    }

    // آپلود عکس
 function resizeAndCropImage($sourcePath, $targetPath, $targetWidth=600, $targetHeight=600){
    $info = getimagesize($sourcePath);
    if (!$info) return false;

    $width = $info[0];
    $height = $info[1];
    $mime = $info['mime'];

    // بارگذاری تصویر بر اساس نوع
    switch($mime){
        case 'image/jpeg': $img = imagecreatefromjpeg($sourcePath); break;
        case 'image/png': $img = imagecreatefrompng($sourcePath); break;
        case 'image/gif': $img = imagecreatefromgif($sourcePath); break;
        default: return false;
    }

    // نسبت تصویر
    $src_ratio = $width / $height;
    $dst_ratio = $targetWidth / $targetHeight;

    if ($src_ratio > $dst_ratio) {
        // تصویر عریض است → کات از عرض
        $new_height = $height;
        $new_width = $height * $dst_ratio;
        $src_x = ($width - $new_width) / 2;
        $src_y = 0;
    } else {
        // تصویر بلند است → کات از ارتفاع
        $new_width = $width;
        $new_height = $width / $dst_ratio;
        $src_x = 0;
        $src_y = ($height - $new_height) / 2;
    }

    $dst_img = imagecreatetruecolor($targetWidth, $targetHeight);

    // حفظ شفافیت PNG و GIF
    if($mime==='image/png' || $mime==='image/gif'){
        imagecolortransparent($dst_img, imagecolorallocatealpha($dst_img, 0,0,0,127));
        imagealphablending($dst_img, false);
        imagesavealpha($dst_img,true);
    }

    // ری‌سایز و کات
    imagecopyresampled($dst_img, $img, 0,0, $src_x,$src_y, $targetWidth,$targetHeight, $new_width,$new_height);

    // ذخیره تصویر
    switch($mime){
        case 'image/jpeg': imagejpeg($dst_img, $targetPath, 85); break; // کیفیت ۸۵
        case 'image/png': imagepng($dst_img, $targetPath, 6); break;    // فشرده‌سازی ۶
        case 'image/gif': imagegif($dst_img, $targetPath); break;
    }

    imagedestroy($img);
    imagedestroy($dst_img);

    return true;
}







 if (!empty($_FILES['image']['name'])) {
    $file = $_FILES['image'];
    if ($file['error'] === UPLOAD_ERR_OK) {
        $filename = time() . "_" . basename($file['name']);
        $target = $uploadDir . $filename;

        // ری‌سایز و کراپ
        if(resizeAndCropImage($file['tmp_name'], $target, 600, 600)){
            $image = "uploads/" . $filename;
        } else {
            echo json_encode(['success'=>false,'message'=>'خطا در پردازش تصویر']);
            exit;
        }
    } else {
        echo json_encode(['success'=>false,'message'=>'خطای آپلود فایل: ' . $file['error']]);
        exit;
    }
}

 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 

    try{
        $pdo->beginTransaction();

        // درج در Category (سطح ۳)
        $stmt=$pdo->prepare("INSERT INTO Category (ParentID, Level, SortOrder) VALUES (:p,3,0)");
        $stmt->execute([':p'=>$parent_id]);
        $cat_id=$pdo->lastInsertId();

        // درج ترجمه‌ها
        foreach($langs as $lg){
            $name=$_POST["name_$lg"] ?? '';
            $desc=$_POST["desc_$lg"] ?? '';
            $stmt=$pdo->prepare("INSERT INTO CategoryTranslation (CategoryID,LanguageCode,Name,Description)
                                 VALUES (:id,:lg,:name,:desc)");
            $stmt->execute([':id'=>$cat_id,':lg'=>$lg,':name'=>$name,':desc'=>$desc]);
        }

        // درج جزئیات آیتم
        $stmt=$pdo->prepare("INSERT INTO ItemDetail (CategoryID,Price,Image,SortOrder)
                             VALUES (:cid,:pr,:img,0)");
        $stmt->execute([':cid'=>$cat_id,':pr'=>$price,':img'=>$image]);

        $pdo->commit();
        echo json_encode(['success'=>true]);
    }catch(Exception $e){
        $pdo->rollBack();
        echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
    }
    exit;
}






// ---------- ویرایش آیتم سطح ۳ ----------
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='edit_item') {
    header('Content-Type: application/json; charset=utf-8');
    $id = (int)($_POST['id'] ?? 0);
    $langs = ['fa','en','tr','ar'];
    $price = $_POST['price'] ?? null;
    $image = null;

    $uploadDir = __DIR__."/uploads/";
    if(!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

    // آپلود تصویر جدید (اختیاری)
    if(!empty($_FILES['image']['name'])){
        $file = $_FILES['image'];
        if($file['error'] === UPLOAD_ERR_OK){
            $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
            $filename = time()."_".rand(1000,9999).".".$ext;
            $target = $uploadDir.$filename;

            if(resizeAndCropImage($file['tmp_name'], $target, 600, 600)){
                $image = "uploads/".$filename;
            } else {
                echo json_encode(['success'=>false,'message'=>'خطا در پردازش تصویر']);
                exit;
            }
        } else {
            echo json_encode(['success'=>false,'message'=>'خطای آپلود فایل: '.$file['error']]);
            exit;
        }
    }

    try{
        $pdo->beginTransaction();

        // بروزرسانی ترجمه‌ها
        foreach($langs as $lg){
            $name = $_POST["name_$lg"] ?? '';
            $desc = $_POST["desc_$lg"] ?? '';
            $stmt = $pdo->prepare("INSERT INTO CategoryTranslation (CategoryID,LanguageCode,Name,Description)
                                   VALUES (:id,:lg,:name,:desc)
                                   ON DUPLICATE KEY UPDATE Name=:name, Description=:desc");
            $stmt->execute([':id'=>$id, ':lg'=>$lg, ':name'=>$name, ':desc'=>$desc]);
        }

        // بروزرسانی جزئیات آیتم
        if($image){
            $stmt = $pdo->prepare("UPDATE ItemDetail SET Price=:pr, Image=:img WHERE CategoryID=:cid");
            $stmt->execute([':cid'=>$id, ':pr'=>$price, ':img'=>$image]);
        } else {
            $stmt = $pdo->prepare("UPDATE ItemDetail SET Price=:pr WHERE CategoryID=:cid");
            $stmt->execute([':cid'=>$id, ':pr'=>$price]);
        }

        $pdo->commit();
        echo json_encode(['success'=>true]);
    }catch(Exception $e){
        $pdo->rollBack();
        echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
    }
    exit;
}









// ---------- حذف آیتم سطح ۳ ----------
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='delete_item') {
    header('Content-Type: application/json; charset=utf-8');
    $id=(int)$_POST['id'];

    try{
        $pdo->beginTransaction();

        $pdo->prepare("DELETE FROM ItemDetail WHERE CategoryID=:id")->execute([':id'=>$id]);
        $pdo->prepare("DELETE FROM CategoryTranslation WHERE CategoryID=:id")->execute([':id'=>$id]);
        $pdo->prepare("DELETE FROM Category WHERE CategoryID=:id")->execute([':id'=>$id]);

        $pdo->commit();
        echo json_encode(['success'=>true]);
    }catch(Exception $e){
        $pdo->rollBack();
        echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
    }
    exit;
}


// ---------- توابع ----------
function getCategories(PDO $pdo, int $level, $parent=null, string $lang='fa') {
    $sql="SELECT c.CategoryID, c.ParentID, c.Level, c.SortOrder, ct.Name
          FROM Category c
          LEFT JOIN CategoryTranslation ct 
                 ON c.CategoryID=ct.CategoryID AND ct.LanguageCode=:lang
          WHERE c.Level=:lvl";
    $p=[":lvl"=>$level, ":lang"=>$lang];
    if ($parent===null) { 
        $sql.=" AND c.ParentID IS NULL"; 
    } else { 
        $sql.=" AND c.ParentID=:p"; 
        $p[':p']=$parent; 
    }
    $sql.=" ORDER BY c.SortOrder ASC";
    $st=$pdo->prepare($sql);
    $st->execute($p);
    return $st->fetchAll();
}

function getItemDetail(PDO $pdo,int $cat,string $lang='fa'){
    $sql="SELECT i.Price, idt.Description
          FROM ItemDetail i
          LEFT JOIN ItemDetailTranslation idt 
                 ON i.ItemID=idt.ItemID AND idt.LanguageCode=:lang
          WHERE i.CategoryID=:c LIMIT 1";
    $st=$pdo->prepare($sql); 
    $st->execute([':c'=>$cat, ':lang'=>$lang]);
    return $st->fetch();
}

function getTranslation(PDO $pdo,int $cat,string $lang){
    $st=$pdo->prepare("SELECT Name FROM CategoryTranslation WHERE CategoryID=:id AND LanguageCode=:lg");
    $st->execute([':id'=>$cat,':lg'=>$lang]);
    return $st->fetchColumn() ?: '';
}

$level1=getCategories($pdo,1,null,$lang);
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8" name="viewport" content="width=device-width, initial-scale=1" />
<title>مدیریت دسته‌ها</title>
<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.2/Sortable.min.js"></script>
<script type="module" src="js/main.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
<link href="css/admin.css?v=1.0" rel="stylesheet">


<style>
.langs a.active { color: #000; text-decoration: underline;}
.list-group-item{cursor:grab}
.handle{margin-left:8px;color:#888;cursor:grab}
.toast-container{position:fixed;bottom:1rem;left:1rem;z-index:9999}

/* بهبود استایل برای درگ اند دراپ */
.draggable-item { cursor: grab; transition: all 0.3s ease;}
.draggable-item:hover {  background-color: #f0f0f0;}
.draggable-item:active {  cursor: grabbing;}
.sortable-ghost {  opacity: 0.7;  background-color: #e6f7ff !important;}
.sortable-chosen {  background-color: #f0f0f0;  box-shadow: 0 0 10px rgba(0,0,0,0.1);}
.sortable-drag {  opacity: 0.9;  box-shadow: 0 5px 15px rgba(0,0,0,0.1);}
.hidden-box { display: none; }
.hidden-box.active { display: block; }


/* بهبود استایل‌های هدر */
.header-level1, .accordion-header {   width: 100%;}
.accordion-button { display: flex;  align-items: center;justify-content: space-between;}
</style>
</head>
<body class="container py-4">
                <!-- منو زبان -->
<div class="langs">
  <a href="?lang=fa" class="<?= $lang=='fa'?'active':'' ?>">فارسی</a>
  <a href="?lang=en" class="<?= $lang=='en'?'active':'' ?>">English</a>
  <a href="?lang=tr" class="<?= $lang=='tr'?'active':'' ?>">Türkçe</a>
  <a href="?lang=ar" class="<?= $lang=='ar'?'active':'' ?>">العربية</a>
</div>

<h4 class="mb-3">مدیریت دسته‌ها (سه سطحی)</h4>
                    
                   <!-- افزودن مجموعه -->
                    <div class="add-form-class form-level1-class">
                       <label for="toggle" class="show-button"> + مجموعه جدید</label>
        <input type="checkbox" id="toggle">
        <div class="hidden-creature">
            <div class="creature-content">
                <!-- فرم افزودن دسته سطح ۱ -->
<div class="form-main">
    <div class="form-main-header">
    <label for="toggle" class="close-button"><i class="fas fa-times"></i></label>
    <h3>افزودن مجموع جدید</h3>
    </div>
  <form id="add_level1" class="add-form form-main1">
    <div class="form-group">
    <input type="text" name="name_fa" placeholder="نام فارسی" >
    </div>
    <div class="form-group">
    <input type="text" name="name_en" placeholder="نام انگلیسی" >
    </div>
    <div class="form-group">
    <input type="text" name="name_tr" placeholder="نام ترکی" >
    </div>
    <div class="form-group">
    <input type="text" name="name_ar" placeholder="نام عربی" >
    </div>
    <div class="form-actions">
    <button type="submit" class="btn-submit">ذخیره</button>
    <button type="button" class="btn-cancel" data-target="edit<?= $catID ?>">انصراف</button>  
    </div>
  </form>
</div>
        </div>
        </div>
                       </div>  

                <!-- نمایش و فرم های مجموعه یک -->
<!-- سطح ۱ -->
<ul class="list-group mb-3 level1" data-level="1" data-parent="">
<?php foreach($level1 as $l1): 
    $name1=$l1['Name'] ?: "Category ".$l1['CategoryID'];
    $level2=getCategories($pdo,2,$l1['CategoryID'],$lang);
?>

<li class="list-group-item draggable-item" data-id="<?=$l1['CategoryID']?>">
  <div class="accordion" id="acc<?=$l1['CategoryID']?>">
    <div class="accordion-item">
        <div class="header-level1">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed level1-h1" type="button" data-bs-toggle="collapse" data-bs-target="#col<?=$l1['CategoryID']?>">
                    <div class="handle">☰</div> 
                    <div class="name-level1"> <?=htmlspecialchars($name1)?></div>  
                </button>
                    <div class="icon-admin">
                        <i class="fas fa-plus" title="افزودن زیردسته"></i>
                        <i class="fas fa-trash" title="حذف دسته"></i>
                        <i class="fas fa-edit" title="ویرایش دسته"></i>
                    </div>
            </h2>
        </div>
        
       <!-- باکس هشدار حذف -->
<div class="box-icon hidden-box box-delete confirm-delete">
       <div class="warning-message">
      ⚠️ این عنوان و تمام زیرمجموعه‌ها کامل پاک می‌شود و امکان بازگردانی نیست.
   </div>
   <div class="form-actions">
      <button type="button" class="btn-confirm-delete" data-id="<?=$l1['CategoryID']?>">تأیید</button>
      <button type="button" class="btn-cancel">انصراف</button>
   </div>
</div>
        <!-- فرم افزودن زیردسته -->
<div class="box-icon hidden-box box-add">
       <form class="add-sub-form" data-parent="<?=$l1['CategoryID']?>" data-level="2">
      <?php foreach(['fa'=>'فارسی','en'=>'انگلیسی','tr'=>'ترکی','ar'=>'عربی'] as $lg=>$label): ?>
      <div class="form-group">
        <input type="text" name="name_<?=$lg?>" placeholder="نام <?=$label?>">
      </div>
      <?php endforeach; ?>
      <div class="form-actions">
        <button type="submit" class="btn-submit">ذخیره</button>
        <button type="button" class="btn-cancel">انصراف</button>
      </div>
   </form>
</div>
        <!-- فرم ویرایش سطح ۱ -->
<div class="box-icon hidden-box box-edit">
               <form class="edit-form" data-id="<?=$l1['CategoryID']?>">
              <?php foreach(['fa'=>'فارسی','en'=>'انگلیسی','tr'=>'ترکی','ar'=>'عربی'] as $lg=>$label): ?>
              <div class="form-group">
                <input type="text" name="name_<?=$lg?>" placeholder="نام <?=$label?>" 
                 value="<?=htmlspecialchars(getTranslation($pdo,$l1['CategoryID'],$lg))?>">
              </div>
              <?php endforeach; ?>
              <div class="form-actions">
                <button type="submit" class="btn-submit">ذخیره</button>
                <button type="button" class="btn-cancel">انصراف</button>
              </div>
           </form>
        </div>
        
                        <!--   نمایش و فرم سطح دو-->
      <div id="col<?=$l1['CategoryID']?>" class="accordion-collapse collapse">
        <div class="accordion-body">
          <!-- سطح ۲ -->
          <ul class="list-group level2" data-level="2" data-parent="<?=$l1['CategoryID']?>">
          <?php foreach($level2 as $l2):
              $name2=$l2['Name'] ?: "Category ".$l2['CategoryID'];
              $level3=getCategories($pdo,3,$l2['CategoryID'],$lang);
          ?>
            <li class="list-group-item draggable-item" data-id="<?=$l2['CategoryID']?>">
              <div class="accordion" id="acc2<?=$l2['CategoryID']?>">
                <div class="accordion-item ">
                <div class="header-level1">
                  <h2 class="accordion-header">
                    <button class="accordion-button level2-h1 collapsed " type="button" data-bs-toggle="collapse" data-bs-target="#col2<?=$l2['CategoryID']?>">
                        <div class="handle">☰</div> 
                        <div class="name-level1"> <?=htmlspecialchars($name2)?></div>  
                    </button>
                         <div class="icon-admin">
                            <i class="fas fa-plus" title="افزودن زیردسته"></i>
                            <i class="fas fa-trash" title="حذف دسته"></i>
                            <i class="fas fa-edit" title="ویرایش دسته"></i>
                        </div>
                  </h2>
                  </div>
 
 
  <!-- باکس هشدار حذف -->
<div class="box-icon hidden-box box-delete confirm-delete">
       <div class="warning-message">
      ⚠️ این عنوان و تمام زیرمجموعه‌ها کامل پاک می‌شود و امکان بازگردانی نیست.
   </div>
   <div class="form-actions">
      <button type="button" class="btn-confirm-delete" data-id="<?=$l2['CategoryID']?>">تأیید</button>
      <button type="button" class="btn-cancel">انصراف</button>
   </div>
</div>
                
                  <!-- فرم افزودن زیردسته -->
<!-- فرم افزودن آیتم سطح ۳ -->
<div class="box-icon hidden-box box-add">
   <form class="add-item-form" data-parent="<?=$l2['CategoryID']?>" enctype="multipart/form-data">
      <?php foreach(['fa'=>'فارسی','en'=>'انگلیسی','tr'=>'ترکی','ar'=>'عربی'] as $lg=>$label): ?>
      <div class="form-group">
        <input type="text" name="name_<?=$lg?>" placeholder="نام <?=$label?>">
        <textarea name="desc_<?=$lg?>" placeholder="توضیح <?=$label?>"></textarea>
      </div>
      <?php endforeach; ?>
      <div class="form-group">
        <input type="text" name="price" placeholder="قیمت">
      </div>
      <div class="form-group">
        <input type="file" name="image">
      </div>
      <div class="form-actions">
        <button type="submit" class="btn-submit">ذخیره</button>
        <button type="button" class="btn-cancel">انصراف</button>
      </div>
   </form>
</div>
                  
                       <!-- فرم ویرایش سطح ۲ -->
<div class="box-icon hidden-box box-edit">
                 <form class="edit-form" data-id="<?=$l2['CategoryID']?>">
                <?php foreach(['fa'=>'فارسی','en'=>'انگلیسی','tr'=>'ترکی','ar'=>'عربی'] as $lg=>$label): ?>
                <div class="form-group">
                  <input type="text" name="name_<?=$lg?>" placeholder="نام <?=$label?>" 
                   value="<?=htmlspecialchars(getTranslation($pdo,$l2['CategoryID'],$lg))?>">
                </div>
                <?php endforeach; ?>
                <div class="form-actions">
                  <button type="submit" class="btn-submit">ذخیره</button>
                  <button type="button" class="btn-cancel">انصراف</button>
                </div>
             </form>
          </div>
          
                   <!--  نمایش و فرم سطح 3 -->
                  <div id="col2<?=$l2['CategoryID']?>" class="accordion-collapse collapse">
                    <div class="accordion-body">
                      <!-- سطح ۳ -->
                      <ul class="list-group level3" data-level="3" data-parent="<?=$l2['CategoryID']?>">
                      <?php foreach($level3 as $l3):
                          $name3=$l3['Name'] ?: "Category ".$l3['CategoryID'];
                          $det=getItemDetail($pdo,$l3['CategoryID'],$lang);
                      ?>
                        <li class="list-group-item draggable-item" data-id="<?=$l3['CategoryID']?>">
                            <div class="item-class">
                                <div class="name-sub">
                                    <span class="handle">⋮</span>
                                    <span class="name-item"><?=htmlspecialchars($name3)?></span>
                                    <div class="icon-admin">
                                        <i class="fas fa-trash" title="حذف آیتم"></i>
                                        <i class="fas fa-edit" title="ویرایش آیتم"></i>
                                    </div>
                                </div>
                                
                                
            
            <!-- باکس هشدار حذف -->
<div class="box-icon hidden-box box-delete confirm-delete">
       <div class="warning-message">
      ⚠️ این عنوان و تمام زیرمجموعه‌ها کامل پاک می‌شود و امکان بازگردانی نیست.
   </div>
   <div class="form-actions">
      <button type="button" class="btn-confirm-delete" data-id="<?=$l3['CategoryID']?>">تأیید</button>
      <button type="button" class="btn-cancel">انصراف</button>
   </div>
</div>


<!-- فرم ویرایش سطح ۳ -->
<div class="box-icon hidden-box box-edit">
    <form id="edit-item-<?= $l3['CategoryID'] ?>" class="edit-item-form" data-id="<?= $l3['CategoryID'] ?>" enctype="multipart/form-data">
        <?php foreach(['fa'=>'فارسی','en'=>'انگلیسی','tr'=>'ترکی','ar'=>'عربی'] as $lg=>$label): ?>
        <div class="form-group">
            <label>نام <?= $label ?></label>
            <input type="text" name="name_<?= $lg ?>" value="<?= htmlspecialchars(getTranslation($pdo,$l3['CategoryID'],$lg)) ?>" placeholder="نام <?= $label ?>">
        </div>
        <div class="form-group">
            <label>توضیح <?= $label ?></label>
            <textarea name="desc_<?= $lg ?>" placeholder="توضیح <?= $label ?>"><?= htmlspecialchars($det['Description'] ?? '') ?></textarea>
        </div>
        <?php endforeach; ?>
        
        <div class="form-group">
            <label>قیمت</label>
            <input type="text" name="price" value="<?= htmlspecialchars($det['Price'] ?? '') ?>" placeholder="قیمت">
        </div>
        
        <div class="form-group">
            <label>تصویر جدید (اختیاری)</label>
            <input type="file" name="image" accept="image/*" onchange="previewImage(this, 'preview-<?= $l3['CategoryID'] ?>')">
        </div>

        <?php if(!empty($det['Image'])): ?>
        <div class="form-group">
            <label>تصویر فعلی:</label><br>
            <img src="<?= htmlspecialchars($det['Image']) ?>" id="preview-<?= $l3['CategoryID'] ?>" style="max-width:150px; max-height:150px;">
        </div>
        <?php else: ?>
        <div class="form-group">
            <img id="preview-<?= $l3['CategoryID'] ?>" style="max-width:150px; max-height:150px; display:none;">
        </div>
        <?php endif; ?>

        <div class="form-actions">
            <button type="submit" class="btn-submit">ذخیره</button>
            <button type="button" class="btn-cancel">انصراف</button>
        </div>
    </form>
</div>





      
                                <div class="details" style="display:block;">
                                    <div><b>قیمت:</b> <?=$det['Price']??'—'?></div>
                                    <div><b>توضیح:</b> <?=$det['Description']??'—'?></div>
                                </div>
                            </div>
                        </li>
                      <?php endforeach; ?>
                      </ul>
                    </div>
                  </div>
                </div>
              </div>
            </li>
          <?php endforeach; ?>
          </ul>
        </div>
      </div>
    </div>
  </div>
</li>
<?php endforeach; ?>
</ul>

<!-- Toast -->
<div class="toast-container">
  <div id="toastSaved" class="toast align-items-center text-bg-success border-0" role="alert">
    <div class="d-flex">
      <div class="toast-body">ترتیب با موفقیت ذخیره شد ✅</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
    </div>
  </div>
</div>

<script>
// ----------- فعال‌سازی Sortable برای همه سطوح -----------
function makeSortable(sel, groupName){
  document.querySelectorAll(sel).forEach(function(el){
    new Sortable(el,{
      group: groupName,
      handle: '.draggable-item',
      animation: 250,
      ghostClass: 'sortable-ghost',
      chosenClass: 'sortable-chosen',
      dragClass: 'sortable-drag',
      forceFallback: true,
      fallbackOnBody: true,
      fallbackTolerance: 3,
      onStart: evt => evt.item.classList.add('dragging'),
      onEnd: function(evt) {
        evt.item.classList.remove('dragging');
        let toEl   = evt.to;
        let ids    = [...toEl.querySelectorAll(":scope > li")].map(li => li.dataset.id);
        let parent = toEl.dataset.parent || '';
        let level  = toEl.dataset.level;
        saveOrder(level, parent, ids);
      }
    });
  });
}
makeSortable('.level1','shared');
makeSortable('.level2','shared');
makeSortable('.level3','shared');

// ----------- ذخیره در دیتابیس -----------
function saveOrder(level,parent_id,ids){
  let data=new URLSearchParams();
  data.append("action","save_order");
  data.append("level",level);
  data.append("parent_id",parent_id);
  ids.forEach(id=>data.append("order[]",id));

  fetch("",{
    method:"POST",
    headers:{"Content-Type":"application/x-www-form-urlencoded"},
    body:data
  }).then(r=>r.json()).then(d=>{
    if(d.success){
      let toastEl=document.getElementById('toastSaved');
      if(toastEl){
        let toast=new bootstrap.Toast(toastEl);
        toast.show();
      }
    }else{
      alert("خطا: "+(d.message||''));
    }
  });
}

// ----------- پیش نمایش تصویر -----------
function previewImage(input, previewId) {
  const preview = document.getElementById(previewId);
  if (input.files && input.files[0]) {
    const reader = new FileReader();
    reader.onload = e => {
      preview.src = e.target.result;
      preview.style.display = 'block';
    };
    reader.readAsDataURL(input.files[0]);
  }
}

// ----------- مدیریت فرم‌ها و دکمه‌ها (یکپارچه) -----------
document.addEventListener("DOMContentLoaded", () => {

  // فرم افزودن سطح ۱
  const formLevel1 = document.getElementById("add_level1");
  if(formLevel1){
    formLevel1.addEventListener("submit", function(e){
      e.preventDefault();
      const formData = new FormData(this);
      formData.append("action", "add_category");
      formData.append("level", 1);
      formData.append("parent_id", "");

      fetch("", {method: "POST", body: formData})
      .then(res => res.json())
      .then(data => {
        if(data.success){
          alert("✅ دسته سطح یک اضافه شد");
          location.reload();
        } else {
          alert("❌ خطا: " + (data.message || "عملیات ناموفق بود"));
        }
      })
      .catch(err => alert("❌ خطای ارتباط: " + err));
    });
  }

  // هندل فرم‌ها و دکمه‌ها
  document.addEventListener('submit', function(e){
    const form = e.target;

    // افزودن آیتم
    if(form.classList.contains('add-item-form')){
      e.preventDefault();
      let data=new FormData(form);
      data.append('action','add_item');
      data.append('parent_id', form.dataset.parent);

      fetch("",{method:"POST",body:data})
      .then(r=>r.json()).then(d=>{
        if(d.success){ alert("آیتم افزوده شد ✅"); location.reload(); }
        else{ alert("خطا: "+d.message); }
      });
    }

    // ویرایش آیتم
    if(form.classList.contains('edit-item-form')){
      e.preventDefault();
      let id=form.dataset.id;
      let data=new FormData(form);
      data.append('action','edit_item');
      data.append('id',id);

      fetch("",{method:"POST",body:data})
      .then(r=>r.json()).then(d=>{
        if(d.success){ alert("ویرایش شد ✅"); location.reload(); }
        else{ alert("خطا: "+(d.message||'')); }
      });
    }

    // افزودن زیردسته
    if(form.classList.contains('add-sub-form')){
      e.preventDefault();
      let parent=form.dataset.parent;
      let level=form.dataset.level;
      let data=new FormData(form);
      data.append('action','add_category');
      data.append('parent_id',parent);
      data.append('level',level);

      fetch("",{method:"POST",body:data})
      .then(r=>r.json()).then(d=>{
        if(d.success){ alert("زیردسته افزوده شد ✅"); location.reload(); }
        else{ alert("خطا: "+d.message); }
      });
    }
  });

  // کلیک‌ها
  document.addEventListener('click', function(e){
    const t = e.target;

    // حذف آیتم (قدیمی)
    if(t.classList.contains('btn-confirm-delete-item')){
      let id = t.dataset.id;
      let data = new FormData();
      data.append('action','delete_item');
      data.append('id',id);

      fetch("",{method:"POST",body:data})
      .then(r=>r.json()).then(d=>{
        if(d.success){ alert("آیتم حذف شد ✅"); location.reload(); }
        else{ alert("خطا: "+d.message); }
      });
    }

    // حذف دسته (fa-trash → box-delete → btn-confirm-delete)
    if(t.classList.contains('fa-trash')){
      const parent = t.closest('.draggable-item');
      parent.querySelectorAll('.box-icon').forEach(b => b.classList.remove('active'));
      const box = parent.querySelector('.box-delete');
      if(box) box.classList.add('active');
    }

    if(t.classList.contains('btn-confirm-delete')){
      let id = t.dataset.id;
      let data = new FormData();
      data.append('action','delete_category');
      data.append('id',id);

      fetch("",{method:"POST",body:data})
      .then(r=>r.json()).then(d=>{
        if(d.success){ alert("حذف شد ✅"); location.reload(); }
        else{ alert("خطا: "+(d.message||'')); }
      });
    }

    // افزودن زیردسته
    if(t.classList.contains('fa-plus')){
      const parent = t.closest('.draggable-item');
      parent.querySelectorAll('.box-icon').forEach(b => b.classList.remove('active'));
      const box = parent.querySelector('.box-add');
      if (box) box.classList.add('active');
    }

    // ویرایش دسته
    if(t.classList.contains('fa-edit')){
      const parent = t.closest('.draggable-item');
      parent.querySelectorAll('.box-icon').forEach(b => b.classList.remove('active'));
      const box = parent.querySelector('.box-edit');
      if (box) box.classList.add('active');
    }

    // بستن باکس‌ها
    if(t.classList.contains('btn-cancel')){
      const box = t.closest('.box-icon');
      if (box) box.classList.remove('active');
    }
  });

});














</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
