<form id="add_level1" class="add-form form-main1" dir="<?= $dir ?>">
    <?php if (!empty($languages)): ?>
          <!-- Section -->
                  
        <div class="base-add-level1">
            <?php foreach ($languages as $langRow): ?>
                <?php if ($langRow['code'] == $default_lang): ?>
                    <div class="form-group">
                        <input type="text" 
                               name="name_<?= htmlspecialchars($langRow['code']) ?>" 
                               placeholder="<t>name</t> <?= htmlspecialchars($langRow['name']) ?>">
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
        <!-- Section -->
        <div class="hidden-add-level1" style="display:none;">
            <?php foreach ($languages as $langRow): ?>
                <?php if ($langRow['code'] != $default_lang): ?>
                    <div class="form-group">
                        <input type="text" 
                               name="name_<?= htmlspecialchars($langRow['code']) ?>" 
                               placeholder="<t>name</t> <?= htmlspecialchars($langRow['name']) ?>">
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>

    <?php else: ?>
        <p><t>no_language_defined</t></p>
    <?php endif; ?>

    <div class="form-actions">
        <div class="add-level1-button">
        <button type="button" class="toggle-langs-btn"> <span class="icon-plus"></span><t>add_language</t></button>
          </div>
        <label for="toggle" class="close-button"><t>cancel</t></label>
        <button type="submit" class="btn-submit"><t>save</t></button>
    </div>
</form>

        <!-- Section -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    const toggleBtn = document.querySelector(".toggle-langs-btn");
    const hiddenDiv = document.querySelector(".hidden-add-level1");

    toggleBtn.addEventListener("click", function() {
        if (hiddenDiv.style.display === "none" || hiddenDiv.style.display === "") {
            hiddenDiv.style.display = "block";
            toggleBtn.innerHTML = "<t>close_languages</t>";
        } else {
            hiddenDiv.style.display = "none";
            toggleBtn.innerHTML = "<t>add_languages</t>";
        }
    });
});
</script>
