import { closeAllActionDivs } from './utils.js';

export function initializeModals() {
  // باز کردن فرم‌های ویرایش/افزودن/حذف
  document.querySelectorAll('.edit-action,.add-action,.delete-action').forEach(el => {
    el.addEventListener('click', (e) => {
      e.stopPropagation();
      closeAllActionDivs();
      const target = document.getElementById(el.dataset.target);
      if (target) target.classList.remove('hidden');
    });
  });

  // بستن با ضربدر
  document.querySelectorAll('.close-btn').forEach(btn => {
    btn.addEventListener('click', (e) => {
      e.stopPropagation();
      const targetId = btn.dataset.target;
      if (targetId) {
        const t = document.getElementById(targetId);
        if (t) t.classList.add('hidden');
      }
    });
  });

  // دکمه‌های cancel که data-target دارند
  document.querySelectorAll('.cancel-btn, .btn-cancel').forEach(btn => {
    btn.addEventListener('click', (e) => {
      e.stopPropagation();
      const targetId = btn.dataset.target;
      
      if (targetId) {
        const target = document.getElementById(targetId);
        if (target) {
          target.classList.add('hidden');
        }
      } else {
        // اگر data-target ندارد، والد فرم را پیدا کرده و ببندید
        let formContainer = btn.closest('.edit-level1, .edit-level2, .edit-level3, .delete-level1, .delete-level2, .add-level1, .add-level2');
        if (formContainer) {
          formContainer.classList.add('hidden');
        }
      }
    });
  });
}