// توابع کمکی عمومی
export function closeAllActionDivs() {
  document.querySelectorAll('.delete-level1, .edit-level1, .add-level1, .delete-level2, .edit-level2, .add-level2').forEach(div => {
    div.classList.add('hidden');
  });
}

export function removeRequiredAttributes() {
  document.querySelectorAll("form input, form textarea, form select").forEach(el => {
    el.removeAttribute("required");
  });
}

export function getOpenTabs() {
  const openTabs = [];
  document.querySelectorAll('[id^="cat"]').forEach(div => {
    if (!div.classList.contains('hidden')) {
      openTabs.push(div.id);
    }
  });
  return openTabs;
}

export function restoreOpenTabs() {
  const openCats = JSON.parse(localStorage.getItem('openCategories') || "[]");
  if (openCats.length > 0) {
    openCats.forEach(id => {
      const el = document.getElementById(id);
      if (el) el.classList.remove('hidden');
    });
    localStorage.removeItem('openCategories');
  }
}