<?php
// ---------------- تنظیمات دیتابیس ----------------
$host = "localhost";
$db   = "tabrizli_arkbam";
$user = "tabrizli_arkbamuser";
$pass = "01478520Mi!!";
$charset = "utf8mb4";

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];
try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    die("خطا در اتصال: " . $e->getMessage());
}

session_start();

// ---------------- صفحه فعال ----------------
$page = $_GET['page'] ?? 'home';

// ---------------- عملیات زبان‌ها ----------------
if ($page === 'languages') {
    // حذف زبان
    if (isset($_GET['delete'])) {
        $languageCode = $_GET['delete'];
        // بررسی اینکه زبان پیش‌فرض نباشد
        $checkDefault = $pdo->prepare("SELECT is_default FROM Language WHERE LanguageCode = ?");
        $checkDefault->execute([$languageCode]);
        $lang = $checkDefault->fetch();
        
        if ($lang && $lang['is_default']) {
            $_SESSION['message'] = "❌ نمی‌توان زبان پیش‌فرض را حذف کرد";
        } else {
            $stmt = $pdo->prepare("DELETE FROM Language WHERE LanguageCode = ?");
            $stmt->execute([$languageCode]);
            $_SESSION['message'] = "✅ زبان با موفقیت حذف شد";
        }
        header("Location: index4.php?page=languages");
        exit;
    }
    
    // تعیین زبان پیش‌فرض
    if (isset($_GET['set_default'])) {
        $languageCode = $_GET['set_default'];
        // ابتدا همه زبان‌ها را غیر پیش‌فرض کنیم
        $pdo->exec("UPDATE Language SET is_default = 0");
        // سپس زبان انتخاب شده را پیش‌فرض کنیم
        $stmt = $pdo->prepare("UPDATE Language SET is_default = 1 WHERE LanguageCode = ?");
        $stmt->execute([$languageCode]);
        $_SESSION['message'] = "✅ زبان پیش‌فرض با موفقیت تغییر کرد";
        header("Location: index4.php?page=languages");
        exit;
    }
    
    // فعال/غیرفعال کردن زبان
    if (isset($_GET['toggle_active'])) {
        $languageCode = $_GET['toggle_active'];
        // بررسی اینکه زبان پیش‌فرض نباشد
        $checkDefault = $pdo->prepare("SELECT is_default FROM Language WHERE LanguageCode = ?");
        $checkDefault->execute([$languageCode]);
        $lang = $checkDefault->fetch();
        
        if ($lang && $lang['is_default']) {
            $_SESSION['message'] = "❌ نمی‌توان زبان پیش‌فرض را غیرفعال کرد";
        } else {
            $stmt = $pdo->prepare("UPDATE Language SET active = NOT active WHERE LanguageCode = ?");
            $stmt->execute([$languageCode]);
            $_SESSION['message'] = "✅ وضعیت فعال بودن زبان تغییر کرد";
        }
        header("Location: index4.php?page=languages");
        exit;
    }
    
    // ویرایش زبان
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_id'])) {
        $stmt = $pdo->prepare("UPDATE Language SET LanguageName = ?, is_default = ?, active = ? WHERE LanguageCode = ?");
        $stmt->execute([
            $_POST['name'], 
            $_POST['is_default'] ?? 0, 
            $_POST['active'] ?? 1, 
            $_POST['edit_id']
        ]);
        $_SESSION['message'] = "✅ زبان با موفقیت ویرایش شد";
        header("Location: index4.php?page=languages");
        exit;
    }
    
    // افزودن زبان جدید
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['edit_id'])) {
        // اگر زبان جدید پیش‌فرض باشد، ابتدا همه را غیر پیش‌فرض کنیم
        if (isset($_POST['is_default']) && $_POST['is_default'] == 1) {
            $pdo->exec("UPDATE Language SET is_default = 0");
        }
        
        $stmt = $pdo->prepare("INSERT INTO Language (LanguageCode, LanguageName, is_default, active) VALUES (?, ?, ?, ?)");
        $stmt->execute([
            $_POST['code'], 
            $_POST['name'], 
            $_POST['is_default'] ?? 0, 
            $_POST['active'] ?? 1
        ]);
        $_SESSION['message'] = "✅ زبان جدید با موفقیت افزوده شد";
        header("Location: index4.php?page=languages");
        exit;
    }
}

// ---------------- عملیات ترجمه‌ها ----------------
if ($page === 'translations') {
    // حذف ترجمه
    if (isset($_GET['delete_translation'])) {
        $stmt = $pdo->prepare("DELETE FROM Translations WHERE id = ?");
        $stmt->execute([$_GET['delete_translation']]);
        $_SESSION['message'] = "✅ ترجمه با موفقیت حذف شد";
        header("Location: index4.php?page=translations");
        exit;
    }
    
    // ویرایش ترجمه
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_translation_id'])) {
        $stmt = $pdo->prepare("UPDATE Translations SET LanguageCode = ?, GroupName = ?, KeyName = ?, ValueText = ? WHERE id = ?");
        $stmt->execute([$_POST['language_code'], $_POST['group'], $_POST['key'], $_POST['value'], $_POST['edit_translation_id']]);
        $_SESSION['message'] = "✅ ترجمه با موفقیت ویرایش شد";
        header("Location: index4.php?page=translations");
        exit;
    }
    
    // افزودن ترجمه جدید
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['edit_translation_id'])) {
        $stmt = $pdo->prepare("INSERT INTO Translations (LanguageCode, GroupName, KeyName, ValueText) VALUES (?, ?, ?, ?)");
        $stmt->execute([$_POST['language_code'], $_POST['group'], $_POST['key'], $_POST['value']]);
        $_SESSION['message'] = "✅ ترجمه جدید با موفقیت افزوده شد";
        header("Location: index4.php?page=translations");
        exit;
    }
}

// ---------------- عملیات Import ----------------
if ($page === 'import' && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['json_file'])) {
    $fileContent = file_get_contents($_FILES['json_file']['tmp_name']);
    $data = json_decode($fileContent, true);

    if ($data && isset($data['languages'], $data['translations'])) {
        // وارد کردن زبان‌ها
        foreach ($data['languages'] as $lang) {
            $stmt = $pdo->prepare("INSERT IGNORE INTO Language (LanguageCode, LanguageName, is_default, active) VALUES (?, ?, ?, ?)");
            $stmt->execute([
                $lang['LanguageCode'], 
                $lang['LanguageName'], 
                $lang['is_default'] ?? 0,
                $lang['active'] ?? 1
            ]);
        }
        // وارد کردن ترجمه‌ها
        foreach ($data['translations'] as $tr) {
            $stmt = $pdo->prepare("INSERT INTO Translations (LanguageCode, GroupName, KeyName, ValueText) VALUES (?, ?, ?, ?)");
            $stmt->execute([$tr['LanguageCode'], $tr['GroupName'], $tr['KeyName'], $tr['ValueText']]);
        }
        $_SESSION['message'] = "✅ داده‌ها با موفقیت وارد شدند.";
    } else {
        $_SESSION['message'] = "❌ فایل JSON معتبر نیست.";
    }
    header("Location: index4.php?page=import");
    exit;
}

// ---------------- عملیات Export ----------------
if ($page === 'export' && isset($_GET['download'])) {
    $languages = $pdo->query("SELECT * FROM Language")->fetchAll(PDO::FETCH_ASSOC);
    $translations = $pdo->query("SELECT * FROM Translations")->fetchAll(PDO::FETCH_ASSOC);

    $exportData = [
        "languages" => $languages,
        "translations" => $translations
    ];

    header('Content-Type: application/json');
    header('Content-Disposition: attachment; filename="translations_export.json"');
    echo json_encode($exportData, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

// نمایش پیام‌ها
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>مدیریت زبان‌ها و ترجمه‌ها</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .actions-column { width: 250px; }
        .edit-form { background: #f8f9fa; padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .status-badge { font-size: 0.8rem; }
    </style>
</head>
<body class="container py-4">

    <h1 class="mb-4">🌐 مدیریت زبان‌ها و ترجمه‌ها</h1>
    
    <?php if (isset($message)): ?>
        <div class="alert alert-info"><?= $message ?></div>
    <?php endif; ?>
    
    <a href="index4.php" class="btn btn-secondary">صفحه اصلی</a>
    <a href="index4.php?page=languages" class="btn btn-primary">مدیریت زبان‌ها</a>
    <a href="index4.php?page=translations" class="btn btn-success">مدیریت ترجمه‌ها</a>
    <a href="index4.php?page=import" class="btn btn-warning">ورود (Import)</a>
    <a href="index4.php?page=export" class="btn btn-info">خروجی (Export)</a>
    <hr>

<?php
// ---------------- صفحه اصلی ----------------
if ($page === 'home') {
    echo "<h2>👋 به سیستم مدیریت زبان‌ها خوش آمدید</h2>";
}

// ---------------- مدیریت زبان‌ها ----------------
if ($page === 'languages') {
    $languages = $pdo->query("SELECT * FROM Language ORDER BY is_default DESC, active DESC, LanguageName")->fetchAll(PDO::FETCH_ASSOC);
    $edit_language = null;
    
    if (isset($_GET['edit'])) {
        $stmt = $pdo->prepare("SELECT * FROM Language WHERE LanguageCode = ?");
        $stmt->execute([$_GET['edit']]);
        $edit_language = $stmt->fetch();
    }
    ?>
    
    <h2>📌 لیست زبان‌ها</h2>
    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>کد زبان</th>
                <th>نام زبان</th>
                <th>وضعیت</th>
                <th>پیش‌فرض</th>
                <th class="actions-column">عملیات</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($languages as $lang): ?>
                <tr>
                    <td><?= $lang['LanguageCode'] ?></td>
                    <td><?= $lang['LanguageName'] ?></td>
                    <td>
                        <?php if ($lang['active']): ?>
                            <span class="badge bg-success status-badge">✅ فعال</span>
                        <?php else: ?>
                            <span class="badge bg-danger status-badge">❌ غیرفعال</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($lang['is_default']): ?>
                            <span class="badge bg-success status-badge">✅ پیش‌فرض</span>
                        <?php else: ?>
                            <a href="index4.php?page=languages&set_default=<?= $lang['LanguageCode'] ?>" 
                               class="btn btn-sm btn-outline-success" 
                               onclick="return confirm('آیا می‌خواهید این زبان را به عنوان پیش‌فرض تنظیم کنید؟')">
                                تعیین پیش‌فرض
                            </a>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="index4.php?page=languages&toggle_active=<?= $lang['LanguageCode'] ?>" 
                           class="btn btn-sm <?= $lang['active'] ? 'btn-warning' : 'btn-success' ?>">
                            <?= $lang['active'] ? 'غیرفعال' : 'فعال' ?>
                        </a>
                        <a href="index4.php?page=languages&edit=<?= $lang['LanguageCode'] ?>" class="btn btn-sm btn-info">ویرایش</a>
                        <?php if (!$lang['is_default']): ?>
                            <a href="index4.php?page=languages&delete=<?= $lang['LanguageCode'] ?>" 
                               class="btn btn-sm btn-danger" 
                               onclick="return confirm('آیا از حذف این زبان مطمئن هستید؟')">
                                حذف
                            </a>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="edit-form">
        <h3><?= $edit_language ? '✏️ ویرایش زبان' : '➕ افزودن زبان جدید' ?></h3>
        <form method="POST">
            <?php if ($edit_language): ?>
                <input type="hidden" name="edit_id" value="<?= $edit_language['LanguageCode'] ?>">
                <div class="mb-2">
                    <label class="form-label">کد زبان (غیرقابل تغییر)</label>
                    <input type="text" class="form-control" value="<?= $edit_language['LanguageCode'] ?>" readonly>
                </div>
            <?php else: ?>
                <input name="code" class="form-control mb-2" placeholder="کد زبان (مثلا fa)" required>
            <?php endif; ?>
            
            <input name="name" class="form-control mb-2" placeholder="نام زبان (مثلا فارسی)" 
                   value="<?= $edit_language ? $edit_language['LanguageName'] : '' ?>" required>
            
            <div class="row mb-2">
                <div class="col-md-6">
                    <div class="form-check">
                        <input type="checkbox" name="is_default" value="1" class="form-check-input" id="is_default"
                            <?= ($edit_language && $edit_language['is_default']) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_default">زبان پیش‌فرض</label>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-check">
                        <input type="checkbox" name="active" value="1" class="form-check-input" id="active"
                            <?= ($edit_language && $edit_language['active'] !== 0) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="active">فعال</label>
                    </div>
                </div>
            </div>
            
            <button class="btn btn-primary"><?= $edit_language ? 'بروزرسانی' : 'ذخیره' ?></button>
            <?php if ($edit_language): ?>
                <a href="index4.php?page=languages" class="btn btn-secondary">انصراف</a>
            <?php endif; ?>
        </form>
    </div>
    <?php
}

// ---------------- مدیریت ترجمه‌ها ----------------
if ($page === 'translations') {
    // فقط زبان‌های فعال را نمایش دهید
    $languages = $pdo->query("SELECT * FROM Language WHERE active = 1")->fetchAll(PDO::FETCH_ASSOC);
    $translations = $pdo->query("SELECT t.*, l.LanguageName FROM Translations t JOIN Language l ON l.LanguageCode=t.LanguageCode ORDER BY l.LanguageName, t.GroupName, t.KeyName")->fetchAll(PDO::FETCH_ASSOC);
    
    $edit_translation = null;
    if (isset($_GET['edit_translation'])) {
        $stmt = $pdo->prepare("SELECT * FROM Translations WHERE id = ?");
        $stmt->execute([$_GET['edit_translation']]);
        $edit_translation = $stmt->fetch();
    }
    ?>
    
    <h2>📑 لیست ترجمه‌ها</h2>
    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>زبان</th>
                <th>گروه</th>
                <th>کلید</th>
                <th>مقدار</th>
                <th class="actions-column">عملیات</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($translations as $tr): ?>
                <tr>
                    <td><?= $tr['LanguageName'] ?></td>
                    <td><?= $tr['GroupName'] ?></td>
                    <td><?= $tr['KeyName'] ?></td>
                    <td><?= $tr['ValueText'] ?></td>
                    <td>
                        <a href="index4.php?page=translations&edit_translation=<?= $tr['id'] ?>" class="btn btn-sm btn-warning">ویرایش</a>
                        <a href="index4.php?page=translations&delete_translation=<?= $tr['id'] ?>" 
                           class="btn btn-sm btn-danger" 
                           onclick="return confirm('آیا از حذف این ترجمه مطمئن هستید؟')">
                            حذف
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="edit-form">
        <h3><?= $edit_translation ? '✏️ ویرایش ترجمه' : '➕ افزودن ترجمه جدید' ?></h3>
        <form method="POST">
            <?php if ($edit_translation): ?>
                <input type="hidden" name="edit_translation_id" value="<?= $edit_translation['id'] ?>">
            <?php endif; ?>
            
            <select name="language_code" class="form-control mb-2" required>
                <option value="">-- انتخاب زبان --</option>
                <?php foreach ($languages as $lang): ?>
                    <option value="<?= $lang['LanguageCode'] ?>" 
                        <?= ($edit_translation && $edit_translation['LanguageCode'] == $lang['LanguageCode']) ? 'selected' : '' ?>>
                        <?= $lang['LanguageName'] ?>
                    </option>
                <?php endforeach; ?>
            </select>
            
            <input name="group" class="form-control mb-2" placeholder="گروه (مثلا auth)" 
                   value="<?= $edit_translation ? $edit_translation['GroupName'] : '' ?>" required>
            <input name="key" class="form-control mb-2" placeholder="کلید (مثلا login)" 
                   value="<?= $edit_translation ? $edit_translation['KeyName'] : '' ?>" required>
            <input name="value" class="form-control mb-2" placeholder="مقدار (مثلا ورود)" 
                   value="<?= $edit_translation ? $edit_translation['ValueText'] : '' ?>" required>
            
            <button class="btn btn-success"><?= $edit_translation ? 'بروزرسانی' : 'ذخیره' ?></button>
            <?php if ($edit_translation): ?>
                <a href="index4.php?page=translations" class="btn btn-secondary">انصراف</a>
            <?php endif; ?>
        </form>
    </div>
    <?php
}

// ---------------- Import ----------------
if ($page === 'import') {
    ?>
    <h2>📥 ورود داده‌ها (Import)</h2>
    <form method="POST" enctype="multipart/form-data">
        <input type="file" name="json_file" class="form-control mb-2" accept=".json" required>
        <button class="btn btn-warning">بارگذاری و ورود</button>
    </form>
    <?php
}

// ---------------- Export ----------------
if ($page === 'export') {
    ?>
    <h2>📤 خروجی داده‌ها (Export)</h2>
    <a href="index4.php?page=export&download=1" class="btn btn-info">دانلود JSON</a>
    <?php
}
?>

</body>
</html>