<?php
// ------------------- توابع کمکی -------------------
function getCategories(PDO $pdo,int $level,$parent=null,string $lang='fa'){
    $sql="SELECT c.CategoryID,c.ParentID,c.Level,c.SortOrder,ct.Name
          FROM Category c LEFT JOIN CategoryTranslation ct
          ON c.CategoryID=ct.CategoryID AND ct.LanguageCode=:lang
          WHERE c.Level=:lvl";
    $p=[':lvl'=>$level,':lang'=>$lang];
    if($parent===null) $sql.=" AND c.ParentID IS NULL";
    else {$sql.=" AND c.ParentID=:p"; $p[':p']=$parent;}
    $sql.=" ORDER BY c.SortOrder ASC";
    $st=$pdo->prepare($sql); $st->execute($p);
    return $st->fetchAll();
}

function getItemDetail(PDO $pdo,int $cat,string $lang='fa'){
    $sql="SELECT i.Price,i.Image,ct.Description
          FROM ItemDetail i 
          LEFT JOIN CategoryTranslation ct
          ON i.CategoryID=ct.CategoryID AND ct.LanguageCode=:lang
          WHERE i.CategoryID=:c LIMIT 1";
    $st=$pdo->prepare($sql); $st->execute([':c'=>$cat,':lang'=>$lang]);
    return $st->fetch();
}

function getTranslation(PDO $pdo,int $cat,string $lang){ 
    $st=$pdo->prepare("SELECT Name FROM CategoryTranslation WHERE CategoryID=:id AND LanguageCode=:lg");
    $st->execute([':id'=>$cat,':lg'=>$lang]); 
    return $st->fetchColumn()?:''; 
}






