<?php
session_start();

// گرفتن زبان‌های فعال از دیتابیس
$stmt = $pdo->query("SELECT LanguageCode AS code, LanguageName AS name, is_default 
                     FROM Language 
                     WHERE active = 1 
                     ORDER BY LanguageCode ASC");
$languages = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ------------------- تغییر زبان فعال -------------------
if (isset($_GET['set_lang'])) {
    $code = $_GET['set_lang'];
    
    // بررسی اینکه زبان انتخابی فعال باشد
    $checkActive = $pdo->prepare("SELECT active FROM Language WHERE LanguageCode = ?");
    $checkActive->execute([$code]);
    $isActive = $checkActive->fetchColumn();
    
    if (!$isActive) {
        $_SESSION['message'] = "❌ این زبان غیرفعال است و نمی‌توان آن را انتخاب کرد";
        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    }

    // همه زبان‌ها رو غیر پیش‌فرض کن
    $pdo->exec("UPDATE Language SET is_default = 0");

    // زبان انتخاب‌شده رو پیش‌فرض کن
    $stmt = $pdo->prepare("UPDATE Language SET is_default = 1 WHERE LanguageCode = :code");
    $stmt->execute([':code' => $code]);

    // ذخیره در سشن
    $_SESSION['lang'] = $code;

    // رفرش صفحه با زبان جدید
    header("Location: ?lang=" . urlencode($code));
    exit;
}

// ------------------- تعیین زبان جاری -------------------
$lang = $_GET['lang'] ?? $_SESSION['lang'] ?? null;

if (!$lang) {
    // ابتدا زبان پیش‌فرض فعال را پیدا کن
    $stmt = $pdo->query("SELECT LanguageCode FROM Language WHERE is_default = 1 AND active = 1 LIMIT 1");
    $lang = $stmt->fetchColumn();
    
    // اگر زبان پیش‌فرض فعال نبود، اولین زبان فعال را انتخاب کن
    if (!$lang) {
        $stmt = $pdo->query("SELECT LanguageCode FROM Language WHERE active = 1 LIMIT 1");
        $lang = $stmt->fetchColumn() ?: 'fa';
    }
}

// بررسی اینکه زبان انتخابی فعال باشد
$checkCurrentLang = $pdo->prepare("SELECT active FROM Language WHERE LanguageCode = ?");
$checkCurrentLang->execute([$lang]);
$isCurrentLangActive = $checkCurrentLang->fetchColumn();

// اگر زبان انتخابی غیرفعال است، اولین زبان فعال را انتخاب کن
if (!$isCurrentLangActive) {
    $stmt = $pdo->query("SELECT LanguageCode FROM Language WHERE active = 1 LIMIT 1");
    $lang = $stmt->fetchColumn() ?: 'fa';
}

$_SESSION['lang'] = $lang;
$default_lang = $lang;


// ------------------- جهت متن -------------------
$rtl_langs = ['fa', 'ar'];
$dir = in_array($lang, $rtl_langs) ? 'rtl' : 'ltr';

// ------------------- تغییر زبان پیش‌فرض در تنظیمات سایت -------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['change_default'])) {
    $newLang = $_POST['default_lang'] ?? 'fa';
    
    // بررسی اینکه زبان انتخابی فعال باشد
    $checkActive = $pdo->prepare("SELECT active FROM Language WHERE LanguageCode = ?");
    $checkActive->execute([$newLang]);
    $isActive = $checkActive->fetchColumn();
    
    if ($isActive) {
        $stmt = $pdo->prepare("UPDATE SiteSettings SET setting_value = :lang WHERE setting_key = 'default_lang'");
        $stmt->execute([':lang' => $newLang]);
        echo "<div style='color:green'>✅ زبان پیش‌فرض تغییر کرد</div>";
    } else {
        echo "<div style='color:red'>❌ این زبان غیرفعال است و نمی‌توان آن را انتخاب کرد</div>";
    }
}

// نمایش پیام‌ها
if (isset($_SESSION['message'])) {
    echo "<div style='color:red'>" . $_SESSION['message'] . "</div>";
    unset($_SESSION['message']);
}
?>

