<?php
// ------------------------
// قبل از هر خروجی HTML فراخوانی شود!
// ------------------------

// کش محلی ترجمه‌ها
$translationsCache = [];

/**
 * بارگذاری تمام ترجمه‌های گروه 'admin' برای یک زبان در cache
 */
function loadTranslations($language) {
    global $pdo, $translationsCache;
    if (isset($translationsCache[$language])) {
        return;
    }
    $stmt = $pdo->prepare("
        SELECT KeyName, ValueText
        FROM Translations
        WHERE GroupName = 'admin' AND LanguageCode = ?
    ");
    $stmt->execute([$language]);
    // fetchAll(PDO::FETCH_KEY_PAIR) یک آرایه key=>value برمی‌گرداند
    $translationsCache[$language] = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
}

/**
 * t() — گرفتن ترجمه
 * اگر $language داده نشود، از $GLOBALS['lang'] استفاده می‌کند (در صورت موجود نبودن 'fa' پیش‌فرض).
 */
function t($key, $language = null) {
    global $translationsCache;

    // تعیین زبان جاری (از GLOBALS تا مطمئن باشیم مقدار درست خوانده می‌شود)
    if ($language === null) {
        $language = $GLOBALS['lang'] ?? 'fa';
    }

    // بارگذاری ترجمه‌ها یک‌بار
    loadTranslations($language);

    return $translationsCache[$language][$key] ?? $key;
}

// شروع بافر — باید قبل از اولین خروجی HTML (قبل از DOCTYPE یا هر echo) باشد
ob_start(function ($buffer) {
    return preg_replace_callback('/<t>(.*?)<\/t>/i', function ($matches) {
        // استفاده از t(...) که از $GLOBALS['lang'] استفاده می‌کند
        return t(trim($matches[1]));
    }, $buffer);
});
?>
