<!-- هدر -->
<div class="header header-class">
    <div class="nav-header">
        <a href="#" class="nav-btn menu-header" data-target="#menu-header-box">
            <!-- آیکون منو -->
            <?php include './icons/menu.svg'; ?>
        </a>

        <a href="index.php" class="nav-btn">
            <h1>پنل مدیریت</h1>
        </a>

        <a href="#" class="nav-btn setting-header" data-target="#setting-header-box">
            <!-- آیکون تنظیمات -->
            <?php include './icons/setting.svg'; ?>
        </a>
    </div>
</div>

<!-- باکس‌های مخفی -->
<div class="header-hidden header-hidden-class">
    <!-- باکس تنظیمات -->
    <div id="setting-header-box" class="hidden">
        <button class="close-btn">×</button>
        <h3>تنظیمات</h3>
        <div class="box-content">
            <ul>
                <li><a href="#">پروفایل کاربری</a></li>
                <li><a href="#">تنظیمات اعلان‌ها</a></li>
                <li><a href="#">امنیت</a></li>
                <li><a href="#">زبان و منطقه</a></li>
                <li><a href="#">خروج از سیستم</a></li>
            </ul>
        </div>
    </div>

    <!-- باکس منو -->
    <div id="menu-header-box" class="hidden">
        <button class="close-btn">×</button>
        <h3>منو</h3>
        <div class="box-content">
            <ul>
                <li><a href="#">داشبورد</a></li>
                <li><a href="#">کاربران</a></li>
                <li><a href="#">محصولات</a></li>
                <li><a href="#">سفارشات</a></li>
                <li><a href="#">گزارشات</a></li>
            </ul>
        </div>
    </div>
</div>

<!-- جاوااسکریپت کوتاه و حرفه‌ای -->
<script>
document.addEventListener("DOMContentLoaded", () => {
    const buttons = document.querySelectorAll("[data-target]");
    const boxes = document.querySelectorAll(".hidden");
    const body = document.body;

    const hideAll = () => {
        boxes.forEach(b => b.classList.remove("active"));
        body.style.overflow = "";
    };

    // کلیک روی دکمه‌ها
    buttons.forEach(btn => {
        btn.addEventListener("click", e => {
            e.preventDefault();
            const target = document.querySelector(btn.dataset.target);
            hideAll();
            target.classList.add("active");
            body.style.overflow = "hidden";
        });
    });

    // کلیک روی دکمه بستن
    document.querySelectorAll(".close-btn").forEach(btn => {
        btn.addEventListener("click", hideAll);
    });

    // کلیک بیرون از باکس
    document.addEventListener("click", e => {
        if (!e.target.closest(".hidden") && !e.target.closest("[data-target]")) {
            hideAll();
        }
    });

    // بستن با ESC
    document.addEventListener("keydown", e => {
        if (e.key === "Escape") hideAll();
    });
});
</script>

